//
// Copyright [2009] Autodesk, Inc.  All rights reserved. 
//
// This computer source code and related instructions and comments are the
// unpublished confidential and proprietary information of Autodesk, Inc. and
// are protected under applicable copyright and trade secret law.  They may
// not be disclosed to, copied or used by any third party without the prior
// written consent of Autodesk, Inc.
//
//

// Target size.
float2 fTargetSize : ViewportPixelSize;
float  fGamma = 2.2f;

// The single filter input, i.e. the image to be filtered.
texture SrcTexture;
sampler2D srcMap = sampler_state
{
    Texture = <SrcTexture>;
    MinFilter = Point;
    MagFilter = Point;
    ADDRESSU = CLAMP;
    ADDRESSV = CLAMP;
    ADDRESSW = CLAMP;
};

texture GammaLUTTexture;
sampler1D LUTMap = sampler_state
{
    Texture = <GammaLUTTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
    ADDRESSU = CLAMP;
    ADDRESSV = CLAMP;
    ADDRESSW = CLAMP;
};


struct VS_OUTPUT {
   float4 Pos: POSITION;
   float2 texCoord: TEXCOORD;
};

VS_OUTPUT vs_main(float4 inPos: POSITION){
   VS_OUTPUT o;
   inPos.xy = sign( inPos.xy);
   o.Pos = float4( inPos.xy, 0.0f, 1.0f);
   o.texCoord.xy = (float2(o.Pos.x, -o.Pos.y) + 1.0f) / 2.0f + float2(0.5f, 0.5f) / fTargetSize;
   return o;
}

float4 ps_main_gamma( float2 texCoord: TEXCOORD0 ) : COLOR0
{
	float4 fSrcColor = tex2D(srcMap, texCoord);
	if (0 == fSrcColor.a)
	{
		return fSrcColor;
	}
	float4 fDestColor;
	fDestColor.rgb = pow(fSrcColor.rgb, 1.0f / fGamma);
	fDestColor.a = fSrcColor.a;
	return fDestColor;
}

float4 ps_main_LUT( float2 texCoord: TEXCOORD0 ) : COLOR0
{
	float4 fSrcColor = tex2D(srcMap, texCoord);
	float4 fDestColor;
	fDestColor.r = tex1D(LUTMap, fSrcColor.r);
	fDestColor.g = tex1D(LUTMap, fSrcColor.g);
	fDestColor.b = tex1D(LUTMap, fSrcColor.b);
	fDestColor.a = fSrcColor.a;
	return fDestColor;
}

technique GammaValue
{
    pass p0
    {
		FillMode = Solid;
		AlphaTestEnable = True;
		AlphaRef = 0x0;
		AlphaFunc = NotEqual;
		VertexShader = compile vs_2_0 vs_main();
		PixelShader = compile ps_2_0 ps_main_gamma();
    }
}

technique GammaLUT
{
    pass p0
    {
		FillMode = Solid;
		AlphaTestEnable = True;
		AlphaRef = 0x0;
		AlphaFunc = NotEqual;
		VertexShader = compile vs_2_0 vs_main();
		PixelShader = compile ps_2_0 ps_main_LUT();
    }
}

